/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.controls;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import org.lwjgl.glfw.GLFW;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.controls.ControlsRegister;
import xaero.map.controls.KeyEvent;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiWorldMapSettings;

public class ControlsHandler {
    private MapProcessor mapProcessor;
    private ArrayList<KeyEvent> keyEvents = new ArrayList();
    private ArrayList<KeyEvent> oldKeyEvents = new ArrayList();

    public ControlsHandler(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    private boolean eventExists(KeyMapping kb) {
        for (KeyEvent o : this.keyEvents) {
            if (o.getKb() != kb) continue;
            return true;
        }
        return this.oldEventExists(kb);
    }

    private boolean oldEventExists(KeyMapping kb) {
        for (KeyEvent o : this.oldKeyEvents) {
            if (o.getKb() != kb) continue;
            return true;
        }
        return false;
    }

    public static void setKeyState(KeyMapping kb, boolean pressed) {
        if (kb.m_90857_() != pressed) {
            KeyMapping.m_90837_((InputConstants.Key)kb.getKey(), (boolean)pressed);
        }
    }

    public static boolean isDown(KeyMapping kb) {
        if (kb.getKey().m_84873_() == -1) {
            return false;
        }
        if (kb.getKey().m_84868_() == InputConstants.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)kb.getKey().m_84873_()) == 1;
        }
        if (kb.getKey().m_84868_() == InputConstants.Type.KEYSYM) {
            return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)kb.getKey().m_84873_());
        }
        return false;
    }

    public static boolean isKeyRepeat(KeyMapping kb) {
        return kb != ControlsRegister.keyOpenMap && kb != ControlsRegister.keyOpenSettings;
    }

    public void keyDown(KeyMapping kb, boolean tickEnd, boolean isRepeat) {
        Minecraft mc = Minecraft.m_91087_();
        if (!tickEnd) {
            if (kb == ControlsRegister.keyOpenMap) {
                mc.m_91152_((Screen)new GuiMap(null, null, this.mapProcessor, mc.m_91288_()));
            } else if (kb == ControlsRegister.keyOpenSettings) {
                mc.m_91152_((Screen)new GuiWorldMapSettings());
            } else if (kb == ControlsRegister.keyQuickConfirm) {
                WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
                MapProcessor mapProcessor = worldmapSession.getMapProcessor();
                mapProcessor.quickConfirmMultiworld();
            }
        }
    }

    public void keyUp(KeyMapping kb, boolean tickEnd) {
        if (!tickEnd) {
            // empty if block
        }
    }

    public void handleKeyEvents() {
        KeyEvent ke;
        int i;
        Minecraft mc = Minecraft.m_91087_();
        this.onKeyInput(mc);
        for (i = 0; i < this.keyEvents.size(); ++i) {
            ke = this.keyEvents.get(i);
            if (mc.f_91080_ == null) {
                this.keyDown(ke.getKb(), ke.isTickEnd(), ke.isRepeat());
            }
            if (!ke.isRepeat()) {
                if (!this.oldEventExists(ke.getKb())) {
                    this.oldKeyEvents.add(ke);
                }
                this.keyEvents.remove(i);
                --i;
                continue;
            }
            if (ControlsHandler.isDown(ke.getKb())) continue;
            this.keyUp(ke.getKb(), ke.isTickEnd());
            this.keyEvents.remove(i);
            --i;
        }
        for (i = 0; i < this.oldKeyEvents.size(); ++i) {
            ke = this.oldKeyEvents.get(i);
            if (ControlsHandler.isDown(ke.getKb())) continue;
            this.keyUp(ke.getKb(), ke.isTickEnd());
            this.oldKeyEvents.remove(i);
            --i;
        }
    }

    public void onKeyInput(Minecraft mc) {
        List<KeyMapping> kbs = WorldMap.controlsRegister.keybindings;
        for (int i = 0; i < kbs.size(); ++i) {
            KeyMapping kb = kbs.get(i);
            try {
                boolean pressed;
                boolean bl = pressed = kb.m_90859_() && kb.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.IN_GAME);
                while (kb.m_90859_()) {
                }
                if (mc.f_91080_ != null || this.eventExists(kb) || !pressed) continue;
                this.keyEvents.add(new KeyEvent(kb, false, ControlsHandler.isKeyRepeat(kb), true));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

